(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Oct 22 00:07:58 1989 by luca           *)

unsound interface Store 
export

  (* A pointer is a longword with least significant bit zero.
     An integer is a longword with least significant bit one.
     Loopholing an integer to a pointer and dereferencing the
     pointer may cause an addressing fault on some architectures.
     Loopholing a pointer to an integer will render integer
     arithmetic meaningles on such an integer. *)

  (* An Address is an integer in the range 0..1073741823, that is 
     Address does not span the entire address space. One high bit is lost 
     because of the encoding of integers. Another high bit is lost 
     because negative addresses are forbidden. Membership in the range 
     0..1073741823 is never actually checked. *)

  (* Generating a pointer to a random place in the heap by unsound
     means may break garbage collection and dynamics, even if such a 
     pointer is never dereferenced. *)

  Def Address = Int (* 0..maxInt *)

  byteSize, shortSize, longSize, realSize: Int
  (* Size in bytes of basic storage structures. *)

  error: Exception(Ok)

  loophole(A,B::TYPE a:A):B
  (* Convert a value of type A to type B, with no change of representation. 
     Hope you know what you are doing. *)

  address(A::TYPE a:A):Address
  (* Return the address of a in the heap, i.e. convert a from a pointer
     to an integer. Raise error if a is an immediate (Ok, Bool, Char, 
     Int or Real). *)
  at(A::TYPE addr:Address):A
  (* Return the heap value pointed by addr, i.e. convert addr
     from an integer to a pointer. Raise error if addr is not plausible
     (but there are no guarantees; there had better be a legal value at 
     addr). *)

  clear(addr:Address length:Int):Ok
  (* Zero the store from addr for the given length of bytes. *)
  copy(destAddr,sourceAddr:Address length:Int):Ok
  (* Copy the store from source to destination for the given length
     of bytes. If source and destination overlap, copies in the
     correct order. *)

  getByte(addr:Address):Int
  (* From addr, fetch an unencoded byte; result ~128..127. No checking. *)
  setByte(addr:Address byte:Int):Ok
  (* At addr, store the unencoded value of byte, ~128..127. No checking. *)
  getShort(addr:Address):Int
  (* From even addr, fetch an unencoded short; result ~32768..32767. 
     No checking. *)
  setShort(addr:Address short:Int):Ok
  (* At even addr, store the unencoded value of short, ~32768..32767. 
     No checking. *)
  getLong(addr:Address):Int
  (* From even addr, fetch an unencoded long. Fails if the fetched
     value is not in the range ~1073741824..1073741823. No checking. *)
  setLong(addr:Address long:Int):Ok
  (* At even addr, store the unencoded value of long, 
     ~1073741824..1073741823. No checking. *)
  getReal(addr:Address):Real
  (* From even addr, fetch an unencoded real. Fails if the fetched value
     is not in the range minReal..maxReal. No checking. *)
  setReal(addr:Address real:Real):Ok
  (* At even addr, store the unencoded value of real, minReal..maxReal. 
     No checking. *)

(* --
     OpStoreReadByteCase, OpStoreWriteByteCase, 
     OpStoreReadShortCase, OpStoreWriteShortCase,
     OpStoreReadLongCase, OpStoreWriteLongCase,
     OpStoreShortHiCase, OpStoreShortLoCase,
     OpStoreMakeShortCase, OpStoreLongHiCase,
     OpStoreLongLoCase, OpStoreMakeLongCase,
     OpStoreShortPlusCase, OpStoreShortMinusCase,
     OpStoreShortMultCase, OpStoreLongPlusCase,
     OpStoreLongMinusCase, OpStoreLongMultCase,
     OpStoreShortLessCase, OpStoreShortMoreCase,
     OpStoreShortLessEqCase, OpStoreShortMoreEqCase,
     OpStoreLongLessCase, OpStoreLongMoreCase,
     OpStoreLongLessEqCase, OpStoreLongMoreEqCase,
     OpStoreShortBitAndCase, OpStoreShortBitOrCase,
     OpStoreShortBitXorCase, OpStoreShortBitNotCase,
     OpStoreLongBitAndCase, OpStoreLongBitOrCase,
     OpStoreLongBitXorCase, OpStoreLongBitNotCase,
     OpStoreShortBitTestCase, OpStoreShortBitSetCase,
     OpStoreShortBitClearCase, OpStoreLongBitTestCase,
     OpStoreLongBitSetCase, OpStoreLongBitClearCase,
     OpStoreShortShiftCase, OpStoreShortRotateCase,
     OpStoreShortExtractCase, OpStoreShortInsertCase,
     OpStoreLongShiftCase, OpStoreLongRotateCase,
     OpStoreLongExtractCase, OpStoreLongInsertCase,
     OpStoreLoopholeCase, OpStoreClearCase, OpStoreCopyCase;
  *)

end;
