(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Sun Aug 20 18:47:08 1989 by luca           *)

interface Symbol
import writer: Writer
export

  Def Kind ::TYPE = Int
  (* Client-defined symbol classes. Kind 0 is reserved to mean "no symbol". *)

  T ::TYPE
  (* Symbols. *)

  Table ::TYPE
  (* Symbol tables. *)

  noKind :Kind
  (* The kind 0 *)

  none :T
  (* The symbol of Name="" and Kind=noKind. *)

  newTable() :Table
  (* Create a new symbol table. *)

  name(sym :T) :String
  (* Return the name of a symbol. *)

  class(sym :T) :Kind
  (* Return the kind of a symbol. *)

  get(table :Table name :String size :Int) :T
  (* Returns from the symbol table the symbol whose name is the substring of
     "name" starting at 0 and of size "size". If no symbol of that name exists
     in symbol table returns none. Size must be positive. *)

  put(table :Table name :String size :Int kind :Kind) :T
  (* Returns from the symbol table the symbol whose name is the substring of
     "name" starting at 0 and of size "size". If no symbol of that name exists
     in symbol table it creates a new symbol of given name and kind inserts it
     in symbol table and returns it. Size must be positive. *)

  equal(sym1,sym2 :T) :Bool
  (* True if two symbols have the same name. *)

  print(wr :writer.T sym :T) :Ok
  (* Print the name of a symbol. *)

end;


