(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 01:51:23 1990 by luca           *)

interface Term
import :Msg ident:Ident :Op
export

  (* Abstract syntax trees for program kinds and types, and their 
    allocation routines. *)

  Def Rec KndExp =
    Option
      with var where:Msg_Where end
      kndExpNoneCase
      kndExpIdeCase with var ide:ident.T end
      kndExpTypeCase
      kndExpPowerCase with powerBase:TypExp end
      kndExpOperCase with operSpec:SpecExp operBody:KndExp end
      kndExpAbbrCase
	with abbrTyp:TypExp abbrSel:String end
      kndExpNamedCase
	with name:String var freeVars:FreeVars namedKnd:KndExp end
    end

  and TypExpOpClass =
    Option
      typExpOpBoolCase typExpOpCharCase typExpOpStringCase 
      typExpOpIntCase typExpOpRealCase typExpOpVarCase
      typExpOpLocCase typExpOpArrayCase typExpOpExceptionCase
      typExpOpReaderCase typExpOpWriterCase
      typExpOpDynamicCase typExpOpTimeCase typExpOpValueCase
    end

  and TypExp =
    Option
      with var where:Msg_Where end
      typExpNoneCase
      typExpIdeCase with var ide:ident.T var recTyp:TypExp end
      typExpOpCase with op:TypExpOpClass opArgs:TypExpList end
      typExpFunCase with funSpec:SpecExp funBody:TypExp end
      typExpTupleCase with tupleSpec:SpecExp end
      typExpOptionCase with optionSpec:SpecExp commonIndex:Int end
      typExpOperCase
	with operSpec:SpecExp operRange:KndExp operBody:TypExp end
      typExpApplCase with op:TypExp args:TypExpList end
      typExpProjectCase with projectPath:TypExpPath end
      typExpAbbrCase
	with abbrTyp:TypExp abbrSel:String end
      typExpNamedCase
	with name:String var freeVars:FreeVars namedTyp:TypExp end
      typExpVarCase
	with var instance:TypExp end
    end

  and TypExpPath =
    Option
      typExpPathIdeCase with var projectIde:ident.T end
      typExpPathProjectCase
	with
	  projectVal:TypExpPath
	  projectSel:String
	  var projectIndex:Int
	end
      typExpPathAssessCase
	with
	  assessVal:TypExpPath
	  assessSel:String
	  var assessIndex:Int
	end
    end

  and TypExpList = 
    Option
      nil
      cons with typExp:TypExp rest:TypExpList end
    end

  and FreeVars =
    Option
      freeVarsUnknownCase
      freeVarsNilCase
      freeVarsConsCase
	with ide:ident.T rest:FreeVars end
    end

  and SpecExp =
    Option
      nil
      cons with first:SpecExpItem var where:Msg_Where var rest:SpecExp end
    end

  and SpecExpItem =
    Option
      specExpAbbrKndCase
	with kndAbbrDef:DefExpKnd end
      specExpAbbrTypCase
	with recDef:Bool typAbbrDef:DefExpTyp end
      specExpTypCase
	with typIde:ident.T knd:KndExp end
      specExpValCase
	with valIde:ident.T typ:TypExp end
    end

  and DefExpKnd =
    Option
      nil
      cons with 
        ide:ident.T 
        kindDef:KndExp 
        var where:Msg_Where
        rest:DefExpKnd
      end
    end

  and DefExpTyp =
    Option
      nil
      cons with
        ide:ident.T  kind:KndExp  typeDef:TypExp 
        var runTimeTyp:TypExp var where:Msg_Where rest:DefExpTyp
      end
    end

  typExpOpBool, typExpOpChar, typExpOpString, typExpOpInt, typExpOpReal, 
    typExpOpVar, typExpOpLoc, typExpOpException, typExpOpArray, 
    typExpOpReader, typExpOpWriter, typExpOpDynamic, typExpOpTime, 
    typExpOpValue:TypExpOpClass

  emptyKndExp:KndExp
  newKndExpIde(ide:ident.T where:Msg_Where):KndExp
  typeKndExp:KndExp
  newKndExpPower(powerBase:TypExp where:Msg_Where):KndExp
  newKndExpOper(operSpec:SpecExp operBody:KndExp where:Msg_Where):KndExp
  newKndExpAbbr(abbrTyp:TypExp abbrSel:String where:Msg_Where):KndExp
  newKndExpNamed(name:String freeVars:FreeVars namedKnd:KndExp 
    where:Msg_Where):KndExp

  typExpPathNone:TypExpPath
  newTypExpPathIde(projectIde:ident.T):TypExpPath
  newTypExpPathProject(projectVal:TypExpPath projectSel:String
	projectIndex:Int):TypExpPath
  newTypExpPathAssess(assessVal:TypExpPath assessSel:String
	assessIndex:Int):TypExpPath

  emptyTypExpList:TypExpList
  newTypExpList(typExp:TypExp rest:TypExpList):TypExpList

  unknownFreeVars,emptyFreeVars:FreeVars
  newFreeVar(ide:ident.T rest:FreeVars):FreeVars

  emptyTypExp:TypExp
  newTypExpIde(ide:ident.T where:Msg_Where):TypExp
  newTypExpOp(op:TypExpOpClass opArgs:TypExpList where:Msg_Where):TypExp
  newTypExpNilOp(op:TypExpOpClass where:Msg_Where):TypExp
  newTypExpMonOp(op:TypExpOpClass type:TypExp where:Msg_Where):TypExp
  newTypExpBinOp(op:TypExpOpClass type1,type2:TypExp where:Msg_Where) 
   :TypExp
  newTypExpFun(funSpec:SpecExp funBody:TypExp where:Msg_Where):TypExp
  newTypExpTuple(tupleSpec:SpecExp where:Msg_Where):TypExp
  newTypExpOption(optionSpec:SpecExp commonIndex:Int where:Msg_Where):TypExp
  newTypExpOper(operSpec:SpecExp operRange:KndExp
    operBody:TypExp where:Msg_Where):TypExp
  newTypExpAppl(op:TypExp args:TypExpList where:Msg_Where):TypExp
  newTypExpProject(projectPath:TypExpPath where:Msg_Where):TypExp
  newTypExpAbbr(abbrTyp:TypExp abbrSel:String where:Msg_Where):TypExp
  newTypExpNamed(name:String freeVars:FreeVars namedTyp:TypExp
    where:Msg_Where):TypExp
  newTypExpVar(where:Msg_Where):TypExp

  emptySpecExp:SpecExp
  newSpecExpAbbrKnd(kndAbbrDef:DefExpKnd rest:SpecExp where:Msg_Where) 
   :SpecExp
  newSpecExpAbbrTyp(recDef:Bool typAbbrDef:DefExpTyp
    rest:SpecExp where:Msg_Where):SpecExp
  newSpecExpTyp(typIde:ident.T knd:KndExp rest:SpecExp where:Msg_Where) 
   :SpecExp
  newSpecExpVal(valIde:ident.T typ:TypExp
    rest:SpecExp where:Msg_Where):SpecExp

  specExpWhere(spec:SpecExp):Msg_Where
  specExpLength(spec:SpecExp):Int
  specExpJoin(headSpec,tailSpec:SpecExp):SpecExp

  emptyDefExpKnd:DefExpKnd
  newDefExpKnd(
    ide:ident.T
    kindDef:KndExp
    where:Msg_Where
    rest:DefExpKnd)
   :DefExpKnd

  emptyDefExpTyp:DefExpTyp
  newDefExpTyp(
    ide:ident.T
    kind:KndExp
    typeDef:TypExp
    runTimeTyp:TypExp
    where:Msg_Where
    rest:DefExpTyp)
   :DefExpTyp

  okTypExp, boolTypExp, charTypExp, stringTypExp, intTypExp,
    realTypExp, arrayTypExp, exceptionTypExp:TypExp
  varType(type:TypExp where:Msg_Where):TypExp
  locType(type:TypExp where:Msg_Where):TypExp
  isVarType(type:TypExp):Bool
  isLocType(type:TypExp):Bool
  isModifType(type:TypExp):Bool
  arrayType(type:TypExp where:Msg_Where):TypExp
  isArrayType(type:TypExp):Bool
  exceptionType(type:TypExp where:Msg_Where):TypExp
  typExpOpFstArg(type:TypExp):TypExp

end;
