(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:44:16 1990 by luca           *)

interface Trans
import ident :Ident :Exp :Top :Code :Literal :Comp
export

  (* Translate abstract syntax trees into Quest Machine 
     instructions (not yet bytecodes). *)

  state :
    Tuple
      var printProg :Bool
      var topProgInfo :Comp_ProgInfo
    end
  (* printProg is a print flag to pring the translated programs.
     topProgInfo is the top-level ProgInfo. *)

  topDefExp(
    def :Exp_DefExp 
    local :Comp_CompLocal
    progInfo :Comp_ProgInfo out outProgInfo:Comp_ProgInfo)
    : Literal_Prog
  (* Translate a top-level defExp, given the top-level
     locals and progInfo. Produces also an extended ProgInfo. *)

  valExp(val :Exp_ValExp buff :Comp_CompCode) :Code_OpAddr
  (* Translate a ValExp. *)

  defExp(def :Exp_DefExp buff :Comp_CompCode) :Code_OpAddrList
  (* Transate a defExp. *)

  moduleExp(
    moduleName,moduleInterfaceName :ident.T
    moduleImports :Top_ImportList
    moduleBody :Exp_DefExp
    out progInfo :Comp_ProgInfo)
    :Literal_Prog
  (* Translate a module, as a function of its imports. *)

  Def GetInstanceProc =
    All(ide,interfaceName :ident.T) Literal_T

  linkageExp(
    ide,interfaceName :ident.T
    local :Comp_CompLocal
    getInstance :GetInstanceProc
    out instanceAddr :Code_OpAddr)
    : Literal_Prog
  (* Translate a linkage line, as a recursive application
     of modules instances to their imports. *)

end;

