(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:51:47 1990 by luca           *)

unsound interface Value 
export

  (* Peek and poke of pointer-sized values. See also Store.spec. *)

  T ::TYPE
  (* An arbitrary Quest value (but not an arbitrary memory address). *)

  size :Int
  (* Size of a value (i.e. pointer) in pointees (i.e. bytes). *)

  new(A ::TYPE a :A) :T
  (* Interpret anything as a value.T. *)

  be(A ::TYPE val :T) :A
  (* Interpret a value.T as a value of a given type. *)

  fetch(run :T index :Int) :T
  (* Fetch the value at address run+index. Index in pointees *)

  store(run :T index :Int val :T) :Ok
  (* Store a value at address run+index. Index in pointees *)

end;
