(* Copyright 1989 Digital Equipment Corporation.               *)
(* Distributed only by permission.                             *)
(* Last modified on Mon Jun  4 05:29:45 1990 by luca           *)

interface StringOp
export

  error :Exception(Ok)
  (* Raised when any of the following operation cannot be carried out. *)

  new(size: Int init: Char): String
  (* Create a new string of given length, all initialized to init. *)

  isEmpty(string: String): Bool
  (* Test whether a string is empty. *)

  length(string: String): Int
  (* Return the length of a string. *)

  getChar(string: String index: Int): Char
  (* Extract a character from a string. *)

  setChar(string: String index: Int char: Char): Ok
  (* Replace a character of a string. *)

  getSub(source: String start,size: Int): String
  (* Extract a substring from a string. *)

  setSub(dest: String destStart: Int 
    source: String sourceStart,sourceSize: Int): Ok
  (* Replace a substring of a string. If source and dest are the same,
     copies characters in the appropriate direction. *)

  cat(string1,string2: String): String
  (* Concatenate two strings (same as "<>"). *)

  catSub(string1: String start1,size1: Int
    string2: String start2,size2: Int): String
  (* Concatenate two substrings. *)

  conc(a:Array(String)):String
  (* "string.conc of s1 ... sn end"  is the concatenation of s1..sn *)

  equal(string1,string2: String): Bool
  (* True if two strings have the same length and contents. *)

  equalSub(string1: String start1,size1: Int
    string2: String start2,size2: Int): Bool
  (* True if two substrings have the same length and contents. *)

  precedes(string1,string2: String): Bool
  (* True if two strings are equal or in Ascii lexicographic order. *)

  precedesSub(string1: String start1,size1: Int
    string2: String start2,size2: Int): Bool
  (* True if two substrings are equal or in Ascii lexicographic order. *)

end;
