(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Target.i3.SEQUENT                                     *)
(* Last Modified On Tue Jan 28 08:45:36 PST 1992 By kalsow     *)
(*      Modified On Fri Jan 17 14:04:10 CST 1992 By Paul-Pomes@uiuc.edu *)

INTERFACE Target; (* for SEQUENT *)

(* This interface describes the target architecture *)

CONST
  (* integers *)
  INTSIZE  = 32;
  INTALIGN = 32;
  MAXINT   = 2147483647;
  MININT   = (- 2147483647) - 1;

  (* shorts *)
  SHORTSIZE  =     16;
  SHORTALIGN =     16;
  MAXSHORT   =  32767;
  MINSHORT   = -32768;
  MAXUSHORT  =  65535;
  MINUSHORT  =      0;

  (* characters *)
  CHARSIZE  =    8;
  CHARALIGN =    8;
  MAXCHAR   =  127;
  MINCHAR   = -128;
  MAXSCHAR  =  127;
  MINSCHAR  = -128;
  MAXUCHAR  =  255;
  MINUCHAR  =    0;

  (* booleans *)
  BOOLSIZE  = 8;
  BOOLALIGN = 8;

  (* reals *)
  REALSIZE  = 32;
  REALALIGN = 32;
  MAXREAL   =  "3.40282346638528860e+38";
  MINREAL   = "-3.40282346638528860e+38";
  (*  MINPOSREAL =  1.40129846432481707e-45; *)

  (* longreals *)
  LONGREALSIZE  = 64;
  LONGREALALIGN = 64;
  MAXLONGREAL   =  "1.79769313486231470e+308";
  MINLONGREAL   = "-1.79769313486231470e+308";
  (* MINPOSLONGREAL =  4.94065645841246544e-324; *)

  (* extended reals *)
  EXTENDEDSIZE  = LONGREALSIZE;
  EXTENDEDALIGN = LONGREALALIGN;
  MAXEXTENDED   = MAXLONGREAL;
  MINEXTENDED   = MINLONGREAL;

  (* addresses *)
  ADDRSIZE  = 32;
  ADDRALIGN = 32;
  ADDRUNIT  = 8;

  (* C structures *)
  PCCBITFIELDTYPEMATTERS = TRUE;;   (* use the type rather than the size of
                                      a bit-field to compute alignment *)
  STRUCTURESIZEBOUNDARY = 8;   (* every structure size must be a multiple 
                                  of this *)
  BITFIELDCANOVERLAP = FALSE;  (* a bit field cannot overlap two adjacent 
                                  storage units *)  

  (* NIL checking *)
  FIRSTREADABLEADDR = 0;
  (* Read or write references to addresses in the range [0..FIRSTREADABLE-1]
     will cause an address faults.  Hence, no explicit NIL checks are needed
     for dereferencing with offsets in this range. *)

END Target.

