(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Fault.m3                                              *)
(* Last Modified On Mon Oct 12 09:14:24 PDT 1992 by kalsow     *)

MODULE Fault;

IMPORT Scanner, String, Emit, TextExpr;

VAR file_declared := FALSE;

PROCEDURE Reset () =
  BEGIN
    file_declared := FALSE;
  END Reset;

PROCEDURE DeclareFile (file: String.T) =
  VAR save: Emit.Stream;
  BEGIN
    IF (NOT file_declared) THEN
      file_declared := TRUE;
      save := Emit.Switch (Emit.Stream.TextLiterals);
        Emit.Op ("_PRIVATE _VOLATILE _TXT __file = ");
        TextExpr.EmitRep (file);
        Emit.Op (";\n");
      EVAL Emit.Switch (save);
    END;
  END DeclareFile;

PROCEDURE Gen (routine: TEXT) =
  VAR file: String.T;  line: INTEGER;
  BEGIN
    Scanner.LocalHere (file, line);
    DeclareFile (file);
    Emit.Op  (routine);
    Emit.OpI ("(&__file.str,@);\n", line);
  END Gen;

PROCEDURE StackOverflow () =
  BEGIN
    Gen ("_CHECKSTACKOVERFLOW");
  END StackOverflow;

PROCEDURE Range () =
  BEGIN
    Gen ("_RANGEFAULT");
  END Range;

PROCEDURE Narrow () =
  BEGIN
    Gen ("_NARROWFAULT");
  END Narrow;

PROCEDURE Case () =
  BEGIN
    Gen ("_CASEFAULT");
  END Case;

PROCEDURE TypeCase () =
  BEGIN
    Gen ("_TYPECASEFAULT");
  END TypeCase;

PROCEDURE Return () =
  BEGIN
    Gen ("_RETURNFAULT");
  END Return;

PROCEDURE Assert () =
  BEGIN
    Gen ("_ASSERTFAULT");
  END Assert;

BEGIN
END Fault.
