(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: String.i3                                             *)
(* Last modified on Fri Jun  5 11:58:02 PDT 1992 by kalsow     *)
(*      modified on Sat Feb 24 01:03:39 1990 by muller         *)

INTERFACE String;

IMPORT MBuf;

TYPE T <: ADDRESS;
TYPE QID = RECORD module, item: T END;

TYPE
  Stack = RECORD
    top: INTEGER;
    stk: ARRAY [0..99] OF T;
  END;

PROCEDURE Add (x: TEXT): T;
(* Returns the a string equal to 'x' *)

PROCEDURE AddInt (i: INTEGER): T;
(* Returns the a string equal to decimal representation of i *)

PROCEDURE FromStr (READONLY buf: ARRAY OF CHAR;  length: INTEGER := 99999): T;
(* Returns a string equal to buf[0 .. MIN(HIGH(buf), length-1)]. *)

PROCEDURE Concat (a, b: T): T;
(* Returns the concatenation of two strings *)

PROCEDURE Unique (root: T): T;
(* Returns root appended with a unique integer *)

PROCEDURE ToText (t: T): TEXT;
(* Returns a text equal to t *)

PROCEDURE Put (wr: MBuf.T;  t: T);
(* writes the string on the writer *)

PROCEDURE PutChars (wr: MBuf.T;  t: T);
(* writes the string as a list of characters on the writer *)

PROCEDURE PutStack (wr: MBuf.T; s: Stack);
(* writes the strings of stack on the writer *)

PROCEDURE SetClass (t: T;  class: CARDINAL);
(* puts the string into its own syntactic class *)

PROCEDURE GetClass (t: T): INTEGER;
(* returns the assigned class *)

PROCEDURE Length (t: T): INTEGER;
(* returns the length of the string *)

PROCEDURE GetUID (t: T): INTEGER;
(* returns the string's UID *)

PROCEDURE SetUID (t: T;  uid: INTEGER);
(* sets the string's UID *)

PROCEDURE Hash (t: T): INTEGER;
(* returns a hash value for the string *)

PROCEDURE IsReservedC (t: T): BOOLEAN;
(* returns TRUE iff t is a C reserved word *)

PROCEDURE FileTail (t: T): T;
(* returns the tail of the path t *)

PROCEDURE Initialize ();
PROCEDURE Reset ();

END String.
