(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 20:46:23 PST 1992 by muller                   *)

GENERIC INTERFACE Bag (Hash, HashBagADT);

(* The bag elements are stored in a hash table, with collison resolution 
   by chaining.  In this simple implementation, the size of the hash table
   is fixed and is equal to MAX (initialSize, MinSize) (MinSize is hidden
   in the implementation).

   This interface has the shape of Elt. *)

TYPE
  T <: HashBagADT.T OBJECT METHODS
         new (minSize: CARDINAL := 0): T; 
           (* 'minSize' is the minimal size of the hash table *)
         END;

CONST
  Equal = T.equal;
  Copy  = T.copy;

END Bag.
