(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 20:51:43 PST 1992 by muller                   *)



GENERIC INTERFACE PQueue (Order, OrderPQueueADT);

(* This implementation of priority queues uses a heap to represent the 
   partially ordered tree of queue elements.  See 'Data Structures and
   Algorithms', by Aho, Hopcroft and Ullman, p 143.

   This interface has the shape of Elt. *)

EXCEPTION
  Empty;

TYPE
  T <: OrderPQueueADT.T OBJECT METHODS
         new (initialSize: CARDINAL := 0): T;
         END;

CONST
  Equal = T.equal;
  Copy  = T.copy;

END PQueue.
