(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 20:48:45 PST 1992 by muller                   *)

GENERIC INTERFACE Set (Hash, HashSetADT);

(* The set elements are stored in a hash table, with collison resolution 
   by chaining.  In this simple implementation, the size of the hash table
   is fixed and is equal to MAX (initialSize, MinSize) (MinSize is hidden
   in the implementation).

   This interface has the shape of Elt. *)

TYPE
  T <: HashSetADT.T OBJECT METHODS
         new (minSize: CARDINAL := 0): T; 
           (* 'minSize' is the minimal size of the hash table *)
         END;

CONST
  Equal = T.equal;
  Copy  = T.copy;

END Set.
