(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last modified on Tue Feb 11 20:53:23 PST 1992 by muller                   *)

GENERIC INTERFACE StackADT (Elt);

(* The Stack abstract data TYPE.

   The type 'T' defines the basic operations available from all 
   implementations of stacks.  The 'new' operation may be redefined with
   a different signature in subtypes of 'T'.  Also, subtypes may
   define additional methods.  

   Interfaces that define implementations of Stack may require actual 
   arguments that are more strict than Elt.

   A simple implementation is provided by the SimpleStack interface. *)


EXCEPTION 
  Empty;

TYPE 
  F = PROCEDURE (x: Elt.T) RAISES ANY;
        (* to iterate over the elements of a stack *)

  T = OBJECT METHODS
        new (): T := new;
          (* create (self = NIL) or initialize (self # NIL) a Stack.T *)

        push (x: Elt.T);
          (* push 'x' on 'self' *)
        pop (): Elt.T RAISES {Empty};
          (* if the stack is not empty, remove the element last pushed on 
             'self' and return it. Otherwise, raise 'Empty' *)
        top (): Elt.T RAISES {Empty};
          (* if the stack is not empty, return the element last pushed but
             do not modify 'self'.  Otherwise, raise 'Empty' *)       

        equal (s: T): BOOLEAN;
          (* TRUE iff self and s are equal *)
        isEmpty (): BOOLEAN;
          (* TRUE iff self is empty *)
        size (): CARDINAL;
          (* return the number of elements on the stack *)
        copy (): T;
          (* return a copy of self *)
        map (f: F) RAISES ANY;
          (* apply 'f' to each element of 'self'.  It is an unchecked runtime
             error to modify 'self' while this procedure is active *)
       END;

PROCEDURE new (self: T): T;

END StackADT.
