/* Copyright (C) 1989, Digital Equipment Corporation           */
/* All rights reserved.                                        */
/* See the file COPYRIGHT for a full description.              */

/* Last Modified On Tue Oct 13 09:15:36 PDT 1992 by kalsow     */
/*      Modified On Fri May 15 17:02:15 PDT 1992 by muller     */


/*-------
  These variables are imported by the C generated by the compiler,
  hence they cannot be exported by anything that includes M3Runtime.h
-------*/

#include "M3Machine.h"

/* thread stack parameters:
     stack_grows_down ==> "push" and "call" use lower addresses
     stackLimit       ==> the "maximum" value for the current thread's sp.
     max_stack        ==> the "maximum" value for any stack pointer (sp).
     bottom_of_stack  ==> the "minimum" value for the initial thread's sp
                              (initialized by the linker).
*/
#ifdef _STACK_GROWS_DOWN
_EXPORT int   _M3__stack_grows_down = 1;
_EXPORT char* _M3__stackLimit = 0;
_EXPORT char* _M3__max_stack = 0;
#else
_EXPORT int   _M3__stack_grows_down = 0;
_EXPORT char* _M3__stackLimit = (char*)~0;
_EXPORT char* _M3__max_stack = (char*)~0;
#endif
_EXPORT char* _M3__bottom_of_stack;

_EXPORT char* _M3__handlers;
/* global root of the per-thread exception stack */

_EXPORT _NILCHKCHAR _M3__nil_check_char;
/* dummy variable used in _NILCHECKB macro */

_IMPORT int RT0u__inCritical;
/* very low-level runtime mutex */


/*------------------------------------------------ stack overflow handler ---*/

_EXPORT _M3__StackOverflow (file, line)
char* file;
int line;
{
    /* disable thread switching forever! */
    RT0u__inCritical ++;

    /* disable further stack overflow checking */
    _M3__stackLimit = _M3__max_stack;

    /* finally, call the error reporter */
    RTMisc__StackOverflow (file, line);
};


