(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 28 20:33:13 PST 1992 by stolfi     *)
(*      modified on Wed Sep 25 00:33:01 1991 by kalsow         *)
(*      modified on Wed Jun 26 03:07:05 1991 by muller         *)

INTERFACE Extended;

(* Properties of EXTENDED (for what machine???).

   This package defines some basic properties of the 
   built-in float type EXTENDED.

   Index: EXTENDED; floating-point; generics
*)

TYPE T = EXTENDED;

CONST
  Base: INTEGER = 2;
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 53;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 1.7976931348623157X+308;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 4.9406564584124654X-324;
  (* The minimum positive value in T. *)

  MinPosNormal: T = 2.2250738585072014X-308;
  (* The minimum positive "normal" value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

END Extended.
