(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Oct 13 15:43:33 PDT 1992 by muller     *)
(*      modified on Tue Jun  9 14:10:37 PDT 1992 by kalsow     *)


UNSAFE MODULE FileStream;

IMPORT Unix, M3toC, IOFailure, Rd, Wr, UFileRd, UFileWr, Thread;

PROCEDURE OpenRead (nm: TEXT): Rd.T RAISES {Rd.Failure} =
  VAR fd: INTEGER;
  BEGIN
    fd := Unix.open (M3toC.TtoS (nm), Unix.O_RDONLY, Unix.Mrwrwrw);
    IF (fd < 0) THEN RAISE Rd.Failure (IOFailure.open); END;
    RETURN (UFileRd.New (fd));
  END OpenRead;

PROCEDURE OpenWrite (nm: TEXT): Wr.T RAISES {Wr.Failure} =
  CONST Mode = Unix.O_WRONLY + Unix.O_CREAT + Unix.O_TRUNC;
  BEGIN
    RETURN OpenWriteOrAppend (nm, Mode);
  END OpenWrite;

PROCEDURE OpenAppend (nm: TEXT): Wr.T RAISES {Wr.Failure} =
  <*FATAL Thread.Alerted*>
  CONST Mode = Unix.O_WRONLY + Unix.O_CREAT;
  VAR wr := OpenWriteOrAppend (nm, Mode); 
  BEGIN
    Wr.Seek (wr, Wr.Length (wr));
    RETURN wr;
  END OpenAppend;

PROCEDURE OpenWriteOrAppend (nm: TEXT;  flags: INTEGER): Wr.T 
	  RAISES {Wr.Failure} =
  VAR fd: INTEGER;
  BEGIN
    fd := Unix.open (M3toC.TtoS (nm), flags, Unix.Mrwrwrw);
    IF fd < 0 THEN RAISE Wr.Failure (IOFailure.open); END;
    RETURN (UFileWr.New (fd));
  END OpenWriteOrAppend;

BEGIN
END FileStream.
