(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Tue Mar 24 20:01:26 PST 1992 by muller         *)
(*      modified on Mon Jul  9 16:47:46 PDT 1990 by mjordan    *)

UNSAFE INTERFACE Uexec;

IMPORT Ctypes;

(* Some of the Unix library process control calls. This is not a complete
interface, and should be added to as needed *)

(* Remember that any of the calls which may return an error code in
'Uerror.errno' should be serialized by use of 'UnixMutex.errno'. *)

<*EXTERNAL*> 
PROCEDURE execv(
    name: Ctypes.char_star;
    argv: Ctypes.char_star_star)
    : Ctypes.int
    RAISES {};
    
<*EXTERNAL*> 
PROCEDURE execvp(
    name: Ctypes.char_star;
    argv: Ctypes.char_star_star)
    : Ctypes.int
    RAISES {};
    
<*EXTERNAL*> 
PROCEDURE exect(
    name: Ctypes.char_star;
    argv: Ctypes.char_star_star;
    envp: Ctypes.char_star_star)
    : Ctypes.int
    RAISES {};

<*EXTERNAL*> 
PROCEDURE wait(status: Ctypes.int_star): Ctypes.int RAISES {};

END Uexec.
