MODULE TextTo;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, TextF, Fmt, CharsTo;


<*INLINE*> PROCEDURE Card(
    t: Text.T;
    VAR c: CARDINAL;
    base: Fmt.Base := (*Fmt.*)Decimal)
    : BOOLEAN
    RAISES {} =
  BEGIN
    RETURN CharsTo.Card(SUBARRAY(t^, 0, LAST(t^)), c, base);
  END Card;


<*INLINE*> PROCEDURE Int(
    t: Text.T;
    VAR i: INTEGER;
    base: Fmt.Base := (*Fmt.*)Decimal)
    : BOOLEAN
    RAISES {} =
  BEGIN
    RETURN CharsTo.Int(SUBARRAY(t^, 0, LAST(t^)), i, base);
  END Int;


<*INLINE*> PROCEDURE Bool(t: Text.T; VAR b: BOOLEAN): BOOLEAN RAISES {} =
  BEGIN
    RETURN CharsTo.Bool(SUBARRAY(t^, 0, LAST(t^)), b);
  END Bool;


<*INLINE*> PROCEDURE BasedCard(t: Text.T; VAR c: CARDINAL): BOOLEAN RAISES {} =
  BEGIN
    RETURN CharsTo.BasedCard(SUBARRAY(t^, 0, LAST(t^)), c);
  END BasedCard;


<*INLINE*> PROCEDURE BasedInt(t: Text.T; VAR i: INTEGER): BOOLEAN RAISES {} =
  BEGIN
    RETURN CharsTo.BasedInt(SUBARRAY(t^, 0, LAST(t^)), i);
  END BasedInt;


<*INLINE*> PROCEDURE BigCard(t: Text.T; VAR c: CARDINAL): BOOLEAN RAISES {} =
  BEGIN
    RETURN CharsTo.BigCard(SUBARRAY(t^, 0, LAST(t^)), c);
  END BigCard;


<*INLINE*> PROCEDURE BigInt(t: Text.T; VAR i: INTEGER): BOOLEAN RAISES {} =
  BEGIN
    RETURN CharsTo.BigInt(SUBARRAY(t^, 0, LAST(t^)), i);
  END BigInt;


BEGIN
END TextTo.
