INTERFACE BufferStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO;


CONST
  WholeBuffer = -1;


PROCEDURE Open(
    buffer: REF ARRAY OF CHAR;
    length := WholeBuffer;
    mode := IO.OpenMode.Update;
    name := "buffer")
    : IO.Stream
    RAISES {};
(* Opens a stream which reads from and writes to the given buffer. Any attempt
to write beyond the end of the buffer causes a stream error.
  'buffer' must be non NIL and must have at least one element or a checked
runtime error will result.
  'length' indicates the number of characters at the start of the buffer which
are defined. This is not necessarily the whole buffer e.g. suppose that
'length' was 3 and 'NUMBER(buffer^)' was 6. If the buffer was opened for update
it would be possible to do 3 'IO.Get' operations before hitting the end of the
stream; however it would be possible to do 6 'IO.Put' operations before getting
a stream error because of buffer overflow. If 'length' is 'WholeBuffer' or any
other negative value it is taken to be 'NUMBER(buffer^)' (except for truncating
open modes, see below). It is checked runtime error if 'length' is not less
than or equal to the length of the buffer.
  'mode' indicates the mode of the stream. See the 'IO' interface for more
details. Note that some modes truncate e.g. 'IO.OpenMode.Write'. If a
truncating mode is specified the 'length' argument must be either zero or
negative (negative values will be treated like zero). It is a checked runtime
error if 'mode' is a truncating mode and 'length' is not less than or equal to
zero.
  'name' is the name of the stream, which will be used in any error messages
resulting from an error on the stream and is returned by the 'IO.Name' stream
operation *)

END BufferStream.
