UNSAFE MODULE BulkIO_src EXPORTS BulkIO;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* WARNING: This module assumes knowledge of how ARRAYs are implemented *)

(* Version for SRC Modula-3 *)

IMPORT IO;
IMPORT Ctypes;


TYPE
  ArrayDescriptor = RECORD
    elts: ADDRESS;
    size: INTEGER; (* 1 dimension *)
  END;


<*INLINE*> PROCEDURE FakeArray(
    a: ADDRESS;
    bytes: CARDINAL;
    VAR arr: ArrayDescriptor)
    : UNTRACED REF ARRAY OF CHAR
    RAISES {}=
  BEGIN
    arr.elts := a;
    arr.size := bytes;
    RETURN ADR(arr);
  END FakeArray;


PROCEDURE PutN(s: IO.Stream; a: ADDRESS; bytes: CARDINAL) RAISES {IO.Error}=
  VAR
    arr: ArrayDescriptor;
  BEGIN
    IO.PutN(s, FakeArray(a, bytes, arr)^);
  END PutN;


PROCEDURE GetN(
    s: IO.Stream;
    a: ADDRESS;
    bytes: CARDINAL;
    raiseEndOfStream := FALSE)
    : CARDINAL
    RAISES {IO.Error, IO.EndOfStream}=
  VAR
    arr: ArrayDescriptor;
  BEGIN
    RETURN IO.GetN(s, FakeArray(a, bytes, arr)^, raiseEndOfStream);
  END GetN;


BEGIN

END BulkIO_src.
