INTERFACE TextStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT IO;


PROCEDURE Open(
    text: Text.T := NIL;
    name := "text")
    : IO.Stream
    RAISES {};
(* If 'text' is non NIL a read only stream is opened to 'text'. If 'text' is
NIL a readable and writeable stream is opened (with initial length zero). The
contents of this stream can be converted to a text by the 'Convert' operation.
'name' is the name given to the newly created stream *)

PROCEDURE Convert(s: IO.Stream): Text.T RAISES {IO.Error};
(* Makes a text from all the characters between position 0 and the current
position in 's' (i.e. the chars in [0..IO.Tell(s)-1]). This operation will work
on any readable and seekable stream but is intended for use with a stream
created by 'TextStream.Open' *)

END TextStream.
