INTERFACE Stop;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)


TYPE
  Closure = OBJECT METHODS apply() RAISES {} END;

  CallBack <: REFANY;


PROCEDURE Register(closure: Closure): CallBack RAISES {};
(* Register a closure whose 'apply' method will be called when 'Stop' is
called. Does nothing if 'Stop' has already been called. The result is a handle
on the callback; it is only useful for a later cancellation of the callback -
see 'Cancel'. *)

TYPE
  Proc = PROCEDURE() RAISES {};

PROCEDURE BasicClosure(p: Proc): Closure RAISES {};
(* Makes a closure which calls 'p' *)

PROCEDURE Cancel(VAR c: CallBack) RAISES {};
(* Cancels the given callback and sets it to NIL. Does nothing if 'c' is not a
valid, current callback handle. Does nothing if 'Stop' has already been called
*)

TYPE
  Code = {Good, Bad};

PROCEDURE Stop(code := Code.Good) RAISES {};
(* Apply any registered closures and the exit from the program with the given
code. Any calls to 'Stop', 'Register' or 'Cancel' made from the callback
procedures are ignored. The registered closures are applied in reverse order
i.e. the last to be registered is the first to be called back.
  The 'code' argument is returned to the operating system from which the
program was called (if the operating system has this capability). If 'code' is
'Good' the program is assumed to have completed successfully; 'Bad' indicates
an abnormal termination *)

PROCEDURE Panic(code := Code.Bad) RAISES {};
(* For use in emergency only. Stops the program immediately without calling any
of the registered procedures. By default indicates to the operating system
that termination was abnormal (if possible) *)

END Stop.
