INTERFACE UnixRun;


(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Modula 3 interface built on Unix fork and exec to provide simple support
for running child processes *)

IMPORT OSError;


TYPE
  ChildError <: REFANY; (* Represents an error return from the child process *)

PROCEDURE Command(
    command: TEXT;
    READONLY args: ARRAY OF TEXT)
    : ChildError
    RAISES {OSError.E};
(* Run the given command with the given arguments. If the attempt to fork,
exec and wait for the command fails 'OSError.E' will be raised. Otherwise when
the command has terminated 'Command' will return a 'ChildError' indicating what
happened to the command. A NIL result means success.
  The command is run using 'execvp' so the path is searched for an executable
file called "command". *)

PROCEDURE ShellCommand(
    command: TEXT;
    shell: TEXT := NIL)
    RAISES {OSError.E};
(* fires up a sub shell and hands it 'command' with the given arguments as
input. In this case 'command' is a command followed by arguments, as might
be written on a shell input line. This approach has the advantage that
'command' can contain wildcards, environment variables etc. The disadvantages
are:
1) the extra expense of firing up a shell as well as the command
2) any error when 'command' is run will be caught by the shell and lost.
The shell used is given by the pathname argument 'shell'. If 'shell' is NIL
the shell specified by the SHELL environment variable is used *)

PROCEDURE ChildErrorToText(c: ChildError): TEXT;
(* Construct an appropriate error message for the given error. The resulting
text does not end with a newline, has no leading or trailing spaces and starts
with a capital letter. *)

END UnixRun.
