(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE M3ShowProc;

IMPORT Wr, Fmt;
IMPORT AST, ASTWalk;
IMPORT M3AST_AS;
IMPORT M3CId;
IMPORT M3AST_AS_F;

REVEAL Handle = Public BRANDED OBJECT OVERRIDES callback := Node END;

PROCEDURE NewHandle(wr: Wr.T): Handle=
  BEGIN
    RETURN NEW(Handle, wr := wr);
  END NewHandle;

PROCEDURE Node(h: Handle; n: AST.NODE; vm: ASTWalk.VisitMode)=
  BEGIN
    IF vm = ASTWalk.VisitMode.Entry THEN
      TYPECASE n OF
      | M3AST_AS.Proc_decl(p) =>
          Wr.PutText(h.wr, Fmt.F("  PROCEDURE %s\n",
  	    M3CId.ToText(p.as_id.lx_symrep)));
      ELSE
      END;
    END;  
  END Node;

BEGIN

END M3ShowProc.
