(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE Main;

IMPORT
  ProgName, Stop, M3Args, M3Context, 
  M3DepM3Path,
  M3DepInteract,
  M3LTool, M3CheckTool, M3CWarnTool, M3CharTool, M3ToolFrame;
IMPORT M3AST_all;


  

PROCEDURE Run(context: M3Context.T; <*UNUSED*> rc: INTEGER): INTEGER RAISES {}=
  VAR
   p: M3DepM3Path.T := NIL;
  BEGIN
   WITH tool = M3CheckTool.Handle() DO
    IF M3Args.Find(tool) THEN
      M3DepInteract.Run(M3CheckTool.Name, context, p,
          M3Args.GetString(tool, M3CheckTool.InitialCommands_Arg));
      RETURN 0;
    ELSE
      RETURN -1
    END;
   END;
  END Run;

BEGIN
  EVAL ProgName.Set(M3CheckTool.Name);
  EVAL M3LTool.Initialise();
  M3CWarnTool.Init();
  M3CharTool.Init();
  IF M3ToolFrame.Startup(Run) < 0 THEN
    Stop.Stop(Stop.Code.Bad)
  ELSE
    Stop.Stop(Stop.Code.Good);
  END;
END Main.

