MODULE M3ModGen;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT M3AST_AS;

IMPORT M3AST_AS_F;

IMPORT SeqM3AST_AS_DECL_REVL;

PROCEDURE MakeModule(cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    m, i: M3AST_AS.UNIT;
  BEGIN
    (* Transform tree to a Module *)
    i := cu.as_root;
    TYPECASE cu.as_root OF
    | M3AST_AS.Interface(i_n) =>
        WITH m_n = M3AST_AS.NewModule() DO
          m := m_n;
          m_n.as_unsafe := i_n.as_unsafe;
          m_n.as_import_s := i_n.as_import_s;
          m_n.as_block := i_n.as_block;
          ModifyBlock(m_n.as_block);
        END;

    | M3AST_AS.Interface_gen_def(i_g) =>
        WITH m_g = M3AST_AS.NewModule_gen_def() DO
          m := m_g;
          m_g.as_import_s := i_g.as_import_s;
          m_g.as_block := i_g.as_block;
          ModifyBlock(m_g.as_block);
          m_g.as_id_s := i_g.as_id_s;
        END;
          
    | M3AST_AS.Interface_gen_ins(i_i) =>
        WITH m_i = M3AST_AS.NewModule_gen_ins() DO
          m := m_i;
          m_i.as_unsafe := i_i.as_unsafe;
          m_i.as_gen_id := i_i.as_gen_id;
          m_i.as_id_s := i_i.as_id_s;
        END;
    END; (* typecase *)

    m.as_id := M3AST_AS.NewModule_id();
    m.as_id.lx_symrep := i.as_id.lx_symrep;
    cu.as_root := m;
  END MakeModule;

PROCEDURE ModifyBlock(block: M3AST_AS.Block) RAISES {}=
  BEGIN
    VAR
      iter := SeqM3AST_AS_DECL_REVL.NewIter(block.as_decl_s);
      ns := SeqM3AST_AS_DECL_REVL.Null;
      decl_revl: M3AST_AS.DECL_REVL;
    BEGIN
      WHILE SeqM3AST_AS_DECL_REVL.Next(iter, decl_revl) DO
        TYPECASE decl_revl OF
        | M3AST_AS.Const_decl_s, M3AST_AS.Exc_decl_s, M3AST_AS.Revelation_s,
          M3AST_AS.Var_decl_s => 
            (* drop these *)
        | M3AST_AS.Proc_decl(proc_decl) =>
            proc_decl.as_body := M3AST_AS.NewBlock();
            SeqM3AST_AS_DECL_REVL.AddRear(ns, decl_revl);
        | M3AST_AS.Type_decl_s =>
            (* maybe we should make fake REVEALs? *)
        END;    
      END; (* while *)
      block.as_decl_s := ns;
    END;
  END ModifyBlock;

BEGIN

END M3ModGen.
