(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE M3DepM3Path;

IMPORT SList, FileStamp;
IMPORT M3Path;
IMPORT M3CUnit;

TYPE T <: REFANY;

PROCEDURE Scan(): T;
(* Scan the 'm3path', checking for errors, and returning a handle
on the resulting information. *)

PROCEDURE Dirs(t: T): SList.T;
(* Return the list of directories associated with 't'. The elements
are of type 'M3Path.Elem'. *)

PROCEDURE ValidateDir(t: T; dir: TEXT): M3Path.Elem;
(* Check if "dir" is in the list associated with "t", and
   return the associated "M3Path.Elem", if so. Otherwise
   return NIL.
*)

PROCEDURE DirObjLib(t: T; dir: M3Path.Elem): TEXT;
(* Return the name of any object file library in 'dir',
or NIL if none. *)

TYPE
  Update = {Deleted, Added, Changed};
  UpdateRec = ARRAY Update OF SList.T (* OF SList.TextElem *);

PROCEDURE Interfaces(
    oldt, t: T;
    VAR (*out*) u: UpdateRec;
    inDir: M3Path.Elem := NIL)
   ;
(* Return the units in 't' that are newer than in 'oldt'.
If 'oldt=NIL', all interfaces are returned.
If 'inDir # NIL', then the search is restricted to units in directory 
'inDir' *)

PROCEDURE Modules(
    oldt, t: T;
    VAR (*out*) u: UpdateRec;
    inDir: M3Path.Elem := NIL)
   ;
(* ditto for modules *)

PROCEDURE DirOf(t: T; ut: M3CUnit.Type; name: TEXT): M3Path.Elem;
(* Return a handle on the directory that 'ut, name' is stored in. *)

TYPE Info = RECORD pathName: TEXT := NIL; timeStamp: FileStamp.T := NIL END;

PROCEDURE InfoOf(t: T; ut: M3CUnit.Type; name: TEXT): Info;
(* Return the pathname and file system time stamp for "ut, name";
   The "pathName" field will be NIL if such a unit does not exist.
   the "timeStamp" field will be NIL if it is not available. *)

PROCEDURE UidEqual(t: T; name: TEXT; ut: M3CUnit.Type; 
    uid: M3CUnit.Uid): BOOLEAN;
(* Return TRUE iff the uid of 'name, ut' in 't' equals 'uid' *)

PROCEDURE RealHead(t: TEXT): TEXT;
(* Removes trailing '/', if any from PathName.Head call. *)

END M3DepM3Path.
