INTERFACE WrapStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO, Text;

TYPE T <: IO.Stream;

PROCEDURE Open(
    backingStream: IO.Stream;
    margin: CARDINAL := 80;
    breakChars: Text.T := " \t";
    eol: Text.T := "";
    bol: Text.T := "";
    openMode: IO.OpenMode := IO.OpenMode.Write;
    closeBackingStream: BOOLEAN := FALSE)
    : T RAISES {IO.Error};
(* Open a stream which is a wrapped version of backingStream.  Margin is the
 * maximum line length of the wrapped string.  BreakChars is the collection
 * of characters at which the line will be wrapped.  If it is empty, the line
 * will wrap at any character.  eol and bol are the sequences appended and
 * prepended respectively when a new line break is created.  openMode is the
 * mode of the stream, and should be the same as the mode of backingStream.
 * If closeBackingStream then backingStream will be closed when the wrap stream
 * is closed, otherwise not.
 *)

PROCEDURE Set(
    s: T;
    doWrap: BOOLEAN)
    : BOOLEAN;
(* Turn wrapping on (doWrap is TRUE) or off (doWrap is false) for the stream.
 * Returns the old value of wrapping.  When initially opened, a wrap stream
 * has wrapping on.
 *)

END WrapStream.
