INTERFACE M3Directory;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT M3Extension, Text;

TYPE
  T <: REFANY;

PROCEDURE New(
    d: Text.T;
    exts: M3Extension.TSet
      := M3Extension.TSet{FIRST(M3Extension.T)..LAST(M3Extension.T)})
    : T RAISES {};
(* Create a new handle for the directory and extension set specified.
 * If d = Text.Null(), the handle is for the current directory.
 *)

PROCEDURE Next(
    t: T;
    VAR name: Text.T;
    VAR ext: M3Extension.T)
    : BOOLEAN RAISES {};
(* Iterate over the directory.  The name of the next file in the directory
 * specified to New with an extension in exts is returned.  'name' is
 * the unextended name of the file, 'ext' is the extension.  TRUE is returned
 * if a file is found, FALSE otherwise.
 *)

PROCEDURE Rewind(t: T) RAISES {};
(* Next call to Next on this t starts again at first element.
 *)

END M3Directory.
