(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE AST_Iter;

IMPORT AST;

TYPE Null_T = T OBJECT OVERRIDES next := NullNext END;

PROCEDURE Null(n: NODE): T RAISES {}=
  BEGIN
    RETURN NEW(Null_T);
  END Null;

PROCEDURE NullNext(
    iter: T;
    VAR (*out*) n: AST.NODE
    ): BOOLEAN RAISES {}=
  BEGIN
    RETURN FALSE;
  END NullNext;

EXCEPTION UpdateNotPossible;

PROCEDURE NullUpdate(
    n: NODE;
    iter: T;
    nn: AST.NODE
    ) RAISES {}=
  BEGIN
    RAISE UpdateNotPossible;
  END NullUpdate;

BEGIN
END AST_Iter.
