(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE AST_Name;

IMPORT AST, AST_Init;

(* This view adds an "name" method to an AST.NODE *)

TYPE
  NODE = AST_Init.NODE OBJECT
    METHODS
      name(): TEXT RAISES {} := Null;
      (* return a printname for this node (for debugging/analysis) *)
  END;

REVEAL
  AST.NODE <: NODE;

PROCEDURE Null(n: NODE): TEXT RAISES {};
(* returns a text for a node without a specific 'name' method,
 * of the form "no name for node with typecode " & Fmt.Int(TYPECODE(n)).
 *)


END AST_Name.
