INTERFACE AST_WalkRep;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT AST, AST_Iter;

(* Clients must not apply the 'walk' method directly, but use the ASTWalk
   interface instead. New AST nodes, other than leaf nodes, must provide 
   an implementation of the 'walk' method.
*)

TYPE NODE = AST_Iter.NODE OBJECT
  METHODS
    walk(handle: Handle) RAISES ANY := Null;
    (* "walk" the children of "self", visiting each child in some order
    determined by the concrete method. This is connected into the
    "callback" interface provided by ASTWalk through "handle", which
    provides the "Visit" method used to callback and subsequently walk
    the child's subtree. *)
  END;

REVEAL AST.NODE <: NODE;

TYPE
  Handle <: Handle_public;
  Handle_public = OBJECT
    METHODS
      Visit(n: AST.NODE) RAISES ANY;
  END;

PROCEDURE Null(n: NODE; handle: Handle) RAISES {};
(* returns immediately; used as default method *)

END AST_WalkRep.
