INTERFACE M3LMain;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT M3AST_AS, M3Context, SList, Text;

TYPE
  CuElem = SList.Elem OBJECT cu: M3AST_AS.Compilation_Unit; END;

PROCEDURE Module(c: M3Context.T; mainName: Text.T := NIL): SList.T RAISES {};
(* Returns a list of main modules, according to the following conventions:
   1) If a module named 'mainName' (default DefaultMain() if 'mainName=NIL') 
      exists in 'c' then return it.
   also:
   2) Return all modules that export 'mainName'.
   The list returned consists of CuElem's.
*)

PROCEDURE DefaultMain(): Text.T RAISES {};
(* returns the default name of the main program module; useful in
error messages if working with the default in 'Module'. *)

END M3LMain.
