INTERFACE M3CLexF;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Friends interface for M3CLex *)

IMPORT IO;
IMPORT M3AST_LX, M3CToken, M3CReservedWord, M3CHash, M3CLex;
FROM M3CLex IMPORT T;

TYPE T_public = OBJECT (* friends visible part of an M3CLex.T *)
    stream: IO.Stream := NIL;
    identifiers: M3CReservedWord.Table;
    literals: M3CHash.Table;
    identifier: M3AST_LX.Symbol_rep := NIL;
    literal: M3AST_LX.Literal_rep := NIL;
    line, offset, startOfToken, linesInToken: CARDINAL := 0;
    callBack: M3CLex.CallBack := NIL;
    tokenBuffer: Buffer;
    hashValue: M3CHash.Value := NIL;
  END;
 
REVEAL M3CLex.T <: T_public;

(* Getting and ungetting characters using lookahead buffer *)

<*INLINE*> PROCEDURE Get(t: T): CHAR RAISES {IO.Error, IO.EndOfStream};

<*INLINE*> PROCEDURE Unget(t: T; ch: CHAR) RAISES {};

PROCEDURE ReadId(t: T; firstCh: CHAR): M3CToken.T RAISES {IO.Error};
(* Read an identifier, which begins with "firstCh". Returns either
   the token for the corresponding reservbed word, or "M3CToken.T.Identifier"
*)

PROCEDURE ReadNumericLiteral(
    t: T;
    firstCh: CHAR)
    : M3CToken.T
    RAISES {IO.Error};
(* Read a numeric literal, that begins with "firstCh". *)

PROCEDURE ReadCharLiteral(t: T): M3CToken.T RAISES {IO.Error};
(* Read a character literal *)

PROCEDURE ReadTextLiteral(t: T): M3CToken.T RAISES {IO.Error};
(* Read a TEXT literal. *)

CONST
  IsComment = TRUE;
  IsPragma = FALSE;

PROCEDURE ReadCommentOrPragma(t: T; isComment: BOOLEAN) RAISES {IO.Error};
(* Read a comment or pragma *)

(* Manipulating the token buffer directly. Call these procedures with
   "buffer" = "t.tokenBuffer". *)

TYPE
  Buffer <: REFANY;

PROCEDURE BufferToText(buffer: Buffer; length: CARDINAL): TEXT RAISES {};
(* converts "length" chars from "buffer" to a TEXT and returns the result. *)

<*INLINE*> PROCEDURE BufferPut(
    VAR buffer: Buffer;
    pos: CARDINAL;
    ch: CHAR) RAISES {};
(* stores "ch" as position "pos" in "buffer", possibly adding an overflow
   area (hence VAR). *)

<*INLINE*> PROCEDURE HashAndBufferPut(
    ch: CHAR;
    hashValue: M3CHash.Value;
    VAR buffer: Buffer;
    VAR pos: CARDINAL)
    RAISES {};
(* As "BufferPut", but also calls "M3CHash.AddCharToValue(ch, hashValue)"
   and increments "pos". *)

END M3CLexF.

