MODULE M3CReservedWord;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT M3CHash, M3CToken;


REVEAL
  Id = M3CHash.Id BRANDED OBJECT token := M3CToken.T.Identifier END;
  Table = M3CHash.Table BRANDED OBJECT END;


TYPE
  IdCreator = M3CHash.IdCreator OBJECT
    r: M3CToken.ReservedWord;
  OVERRIDES
    new := NewId;
  END;


PROCEDURE NewId(c: IdCreator; t: Text.T): M3CHash.Id RAISES {}=
  BEGIN
    RETURN NEW(Id, token := c.r);
  END NewId;


PROCEDURE Token(id: Id): M3CToken.T RAISES {}=
  BEGIN
    RETURN id.token;
  END Token;


PROCEDURE New(
    size: CARDINAL;
    idCreator: M3CHash.IdCreator := NIL)
    : Table
    RAISES {}=
  VAR
    table := NEW(Table);
    c := NEW(IdCreator);
    v := M3CHash.NewValue();
  BEGIN
    EVAL M3CHash.New(size, c, table);
    FOR r := FIRST(Array) TO LAST(Array) DO
      c.r := r;
      WITH word = Array[r] DO
        M3CHash.ResetValue(v);
        FOR i := 0 TO Text.Length(word) - 1 DO
          M3CHash.AddCharToValue(Text.GetChar(word, i), v);
        END;
        EVAL M3CHash.EnterTextWithValue(table, v, word);
      END;
    END;
    EVAL M3CHash.SetCreator(table, idCreator);
    RETURN table;
  END New;


BEGIN
END M3CReservedWord.
