MODULE M3CBackEnd_C_cc;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT HashText;
IMPORT Text;

VAR
 table_g: HashText.Table;

TYPE R = REF TargetInitProc;

PROCEDURE RegisterTarget(t: Text.T; p: TargetInitProc) RAISES {}=
  VAR
    id: HashText.Id;
    r: R;
  BEGIN
    IF HashText.Enter(table_g, t, id) THEN
      r := NEW(R); r^ := p;
      HashText.Associate(table_g, id, r);
    END; (* if *)
  END RegisterTarget;

PROCEDURE LookupTarget(
    t: Text.T; 
    VAR (*out*) rp: REF TargetInitProc): BOOLEAN RAISES {}=
  VAR
    id: HashText.Id;
  BEGIN
    IF HashText.Lookup(table_g, t, id) THEN
      rp := NARROW(HashText.Value(table_g, id), R);
      RETURN TRUE;
    ELSE
      RETURN FALSE
    END; (* if *)
  END LookupTarget;

REVEAL
  Iter = BRANDED REF HashText.Iter;

PROCEDURE NewIter(): Iter RAISES {}=
  VAR iter := NEW(Iter);
  BEGIN
    iter^ := HashText.NewIterator(table_g);
    RETURN iter;
  END NewIter;

PROCEDURE Next(iter: Iter; VAR (*out*) t: Text.T; 
    VAR (*out*) rp: REF TargetInitProc): BOOLEAN RAISES {}=
  VAR
    ra: REFANY;
  BEGIN
    IF HashText.Next(iter^, t, ra) THEN
      rp := NARROW(ra, R); RETURN TRUE;
    ELSE
      RETURN FALSE
    END;
  END Next;

BEGIN
  table_g := HashText.New(10);
END M3CBackEnd_C_cc.
