(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE M3DPathTool;

IMPORT M3Args, M3Path, M3Env;

CONST
  Version = "20-Feb-92";

VAR
  tool_g := M3Args.New("m3definepath", "search path tool", Version);

PROCEDURE Check() RAISES {}=
  VAR path: REF ARRAY OF TEXT;
  BEGIN
    IF M3Args.Find(tool_g) THEN
      IF NOT M3Args.GetFlag(tool_g, NOSTD_Arg) THEN
        M3Path.AddDefault(M3Env.Std_Interface_Rep());
      END;
      path := M3Args.GetStringList(tool_g, Define_Arg);
      IF path # NIL THEN
        FOR i := 0 TO NUMBER(path^)-1 DO
          M3Path.AddExplicit(path[i]);
        END; (* for *)
      END; (* if *)
    END; (* if *)
  END Check;

BEGIN
  M3Args.RegisterStringList(tool_g, Define_Arg,
    "specify an explicit path to be used for file searching");
  M3Args.RegisterFlag(tool_g, NOSTD_Arg,
    "suppress default scan of standard repository");
END M3DPathTool.
