MODULE DepthToColor;

IMPORT PaintOp, PaintOpCache, RGB, ColorName;

CONST
  Stack = ARRAY OF RGB.T{RGB.Blue, RGB.Green, RGB.Red, RGB.Yellow,
                              RGB.Cyan, RGB.Magenta}; 


  TextStack = ARRAY OF TEXT{"LightRed", "Green", "LightBlue", "Yellow"};

PROCEDURE Map(depth: INTEGER): PaintOp.T RAISES {}=
  BEGIN 
    IF depth < 0 THEN RETURN PaintOp.Fg ELSE
      RETURN PaintOpCache.FromRGB(ColorName.ToRGB(TextStack[depth]));
(*
      VAR rgb := RGB.T{0.0, 0.0, 0.0};
          div := depth DIV 3;
          mod := depth MOD 3;
      BEGIN
        rgb[mod] := 1.0;
        IF div <= 9 THEN rgb[(mod+1) MOD 3] := FLOAT(div)/10.0;
        ELSIF div < 19 THEN rgb[(mod+2) MOD 3] := FLOAT(div-10)/10.0;
        END;
        RETURN PaintOpCache.FromRGB(rgb);
      END;
*)
    END;
  END Map;

BEGIN
END DepthToColor.
