(* Last modified on Wed Aug  5 12:13:00 PDT 1992 by guarino *)
(*      modified on Sat Aug  1 23:03:33 PDT 1992 by broder *)
MODULE AlgsBase;

IMPORT VBT, Text, FormsVBT, FileStream, Rd, StringSearchAlgClass,
       ZeusPanel, Thread;

PROCEDURE GetData (alg: StringSearchAlgClass.T; VAR p, s: TEXT)
  RAISES {Thread.Alerted} =
  VAR
    file  : TEXT;
    rd    : Rd.T;
    isFile: BOOLEAN;
  BEGIN
    p := "";
    s := "";
    LOCK VBT.mu DO
      TRY
        p := FormsVBT.GetText(alg.data, "pattern");
        file := FormsVBT.GetText(alg.data, "file");
        isFile := FormsVBT.GetBoolean(alg.data, "isFile");
      EXCEPT
      | FormsVBT.Error (msg) => ZeusPanel.ReportError(msg); RETURN;
      | FormsVBT.Unimplemented =>
          ZeusPanel.ReportError("FormsVBT.Unimplemented in Get.Data");
          RETURN;
      END;
    END;
    IF Text.Length(p) = 0 THEN
      ZeusPanel.ReportError("Error: Empty pattern");
      RETURN;
    END;
    IF isFile THEN
      TRY
        rd := FileStream.OpenRead(file);
        s := Rd.GetText(rd, LAST(CARDINAL));
      EXCEPT
        Rd.Failure =>
          ZeusPanel.ReportError("Error: could not read file " & file);
          RETURN;
      END;
      TRY Rd.Close(rd) EXCEPT Rd.Failure => END;
    ELSE
      s := file;
    END;
  END GetData;

BEGIN
END AlgsBase.

