MODULE ListTest EXPORTS Main;

IMPORT List, Wr, Fmt, Text;
FROM Stdio IMPORT stdout;
FROM Test IMPORT done;
<*FATAL ANY*>

PROCEDURE PrintList(wr: Wr.T; name: Text.T; subject: List.T) RAISES {} =

  PROCEDURE DoIt(l: List.T) RAISES {} =
  VAR
    prefix := "";
    f: List.T;
  BEGIN
    Wr.PutText(wr, "(");
    f := l;
    WHILE f # NIL DO
      Wr.PutText(wr, prefix);
      prefix := ", ";
      TYPECASE f.first OF
      | NULL =>
      | List.T(listFoo) =>
	  DoIt(listFoo);
      | Text.T(textFoo) =>
	  Wr.PutText(wr, textFoo);
      | REF INTEGER(intFoo) =>
	  Wr.PutText(wr, Fmt.Int(intFoo^));
      ELSE
	Wr.PutText(wr, "?");
      END; (* typecase *)
      f := f.tail;
    END; (* while *)
    Wr.PutText(wr, ")");
  END DoIt;

BEGIN
  Wr.PutText(wr, name & " -> ");
  DoIt(subject);
  Wr.PutText(wr, "\n");
END PrintList;

PROCEDURE NewInt (i: INTEGER): REF INTEGER =
  VAR x := NEW (REF INTEGER);
  BEGIN
    x^ := i;
    RETURN x;
  END NewInt;

BEGIN
  WITH state = List.List2(List.List2("blah", NewInt(0)),
      	      	      	  List.List2("Blag", NewInt(25))) DO
    PrintList(stdout, "Entire list", state);
    PrintList(stdout, "List.Assoc(..., \"blah\")", List.Assoc(state, "blah"));
    PrintList(stdout, "List.Assoc(..., \"Blag\")", List.Assoc(state, "Blag"));
  END; (* with *)

  done ();
END ListTest.
