(* Last modified on Mon Oct 26 09:51:04 PST 1992 by kalsow *)
(*      modified on Mon Aug  6 23:04:50 PDT 1990 by ellis  *)
(*      modified on Wed Apr  4 20:55:51 1990 by saxe       *)

MODULE Main;
IMPORT Test, Fmt;

VAR
  a  : REAL;
  ar : ARRAY [0..1000] OF REAL;

PROCEDURE Approx(x, y: REAL;  b: BOOLEAN) =
  VAR c := ABS(x - y) < MAX(MAX(ABS(x), ABS(y)) / 20000.0, 1.0E-6);
  BEGIN
    IF (b = c) THEN RETURN END;
    IF (b)
      THEN Test.msg ("ERROR: "& Fmt.Real(x) &" is not near "& Fmt.Real (y));
      ELSE Test.msg ("ERROR: "& Fmt.Real(x) &" is too near "& Fmt.Real (y));
    END;
    Test.check (FALSE);
  END Approx;

BEGIN
    Approx(3.14159265, 3.14159277, TRUE);
    Approx(2.7, 2.8, FALSE);
    Approx(0.0, 0.9e-6, TRUE);
    Approx(0.0, -1.0e5, FALSE);

    ar[ 0 ] := 0.0;
    FOR i := 1 TO LAST (ar) DO
      a       := 2.31596 * FLOAT(i);
      a       := 2.0 * (a - FLOAT(TRUNC(a)) - 0.5);
      a       := a * a * a * a * a * 1.0e8;
      ar[ i ] := a;
      Test.check (a <= 1.0e8);
    END;

    FOR i := FIRST (ar) TO LAST (ar) DO
      IF ar[ i ] >= 0.0 THEN
        Test.checkR (FLOAT(FLOOR(ar[ i ])), FLOAT(TRUNC(ar[ i ])));
      ELSE
        Test.check ((FLOOR(ar[ i ]) = TRUNC(ar[ i ]) - 1) OR
                    (FLOAT(FLOOR(ar[ i ])) = ar[ i ]));
      END;

      Test.check (ABS(FLOAT(ROUND(ar[ i ])) - ar[ i ]) < 0.500001);
 
     FOR j := 1 TO 1000 DO
        Test.checkR (ar[ i ] + ar[ j ], ar[ j ] + ar[ i ]);
        Approx((ar[ i ] * ar[ j ]) * ar[ j ],
                ar[ i ] * (ar[ j ] * ar[ j ]), TRUE);
        Approx((ar[ i ] / ar[ j ]) * ar[ j ], ar[ i ], TRUE);
        Approx((ar[ i ] + ar[ j ]) * (ar[ i ] - ar[ j ]),
                ar[ i ] * ar[ i ] - ar[ j ] * ar[ j ], TRUE);
        Test.checkI (FLOOR(MIN(ar[ i ], ar[ j ])),
                     MIN(FLOOR(ar[ j ]), FLOOR(ar[ i ])));
        Test.checkR (MIN(ar[ i ], ar[ j ]) + MAX(ar[ i ], ar[ j ]),
                     ar[ i ] + ar[ j ]);
     END;
   END;

   Test.done ();

END Main.

