(* Copyright (C) 1990, Digital Equipment Corporation.             *)
(* All rights reserved.                                           *)
(* See the file COPYRIGHT for a full description.                 *)


(* Last modified on Tue Jun 23 10:42:31 PDT 1992 by schilit@xerox.com      *)
(*      modified on Thu Jul 25 20:16:14 PDT 1991 by stolfi                 *)
(*      modified on Mon Apr 22 17:42:17 1991 by nichols@xerox.com          *)
(*      modified on Tue Apr 10 23:47:30 1990 by muller                     *)


UNSAFE MODULE Parse;

IMPORT NewFormatter AS Formatter;
IMPORT Ctypes, FBE, M3toC;

<* FATAL FBE.Failed *>

PROCEDURE FalseProc (
    <*UNUSED*> arg: REFANY;
    <*UNUSED*> column: CARDINAL;
    <*UNUSED*> maxWidth: REAL;
    <*UNUSED*> width: REAL
  ): BOOLEAN =
  BEGIN
    RETURN FALSE;
  END FalseProc;

(* Do various setups, then call C init routine. *)
PROCEDURE Init (         inputFile      : TEXT;
                         output         : Formatter.T;
                READONLY info           : Options;
                         calledFromEmacs: BOOLEAN      ) RAISES {FBE.Failed} =
  VAR
    bf, kf, bif, pf, cf, fcf, ff: FBE.Font;
    infile                      : Ctypes.char_star := NIL;
    fbe: FBE.T := Formatter.UnderlyingFBE(output);
  BEGIN
    bf := fbe.GetFont(info.bodyFont);
    kf := fbe.GetFont(info.keywordFont);
    bif := fbe.GetFont(info.builtinIDFont);
    pf := fbe.GetFont(info.procNameFont);
    cf := fbe.GetFont(info.commentFont);
    fcf := fbe.GetFont(info.fixedCommentFont);
    ff := fbe.GetFont(info.fixedFont);
    IF inputFile # NIL THEN infile := M3toC.TtoS(inputFile); END;
    initParser(
      infile := infile, output := output, emacs := calledFromEmacs,
      lowerCase := info.lowerCase, bf := bf, kf := kf, bif := bif, pf := pf,
      cf := cf, fcf := fcf, ff := ff,
      offset := info.offset * fbe.CharWidth(' ', bf),
      commentColumn := info.commentColumn * fbe.CharWidth(' ', bf),
      style := info.style, alignDecls := info.alignDecls,
      breakType := info.breakType, follow (* comBreakNLs *) := info.follow,
      callSpace := info.callSpace);
  END Init;

(* Called from the C code. *)
PROCEDURE CharWidth(f: Formatter.T; font: FBE.Font; c: CHAR): REAL =
  VAR fbe := Formatter.UnderlyingFBE(f);
  BEGIN
    RETURN fbe.CharWidth(c, font);
  END CharWidth;

BEGIN
  falsePred := NEW(Formatter.AlignPred, pred := FalseProc);
END Parse.
