(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:09:05 PDT 1992 by muller     *)
(*      modified on Mon Dec  9 15:35:57 PST 1991 by meehan     *)
(*      modified on Mon Nov 18 10:29:28 PST 1991 by mhb        *)

MODULE AnchorSwitchVBT;

IMPORT AnchorBtnVBT, Feedback, Multi, MultiClass, VBT;

REVEAL
  T = Public BRANDED "AnchorSwitchVBT.T" OBJECT OVERRIDES init := Init END;
            
PROCEDURE Init (v             : T;
                f             : Feedback.T;
                menu          : VBT.T;
                n             : CARDINAL     := 0;
                anchorParent  : VBT.T        := NIL;
                hfudge, vfudge               := 0.0  ): T =
  BEGIN
    EVAL AnchorBtnVBT.T.init (v, f, menu, n, anchorParent, hfudge, vfudge);
    MultiClass.Be (v, NEW (MC));
    MultiClass.BeChild (v, Multi.Child (f));
    RETURN v
  END Init;

BEGIN
END AnchorSwitchVBT.




