(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Mon Aug 10  0:19:33 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:09:03 PDT 1992 by muller *)
(* modified on Mon Jun 15 21:01:59 1992 by mhb *)
(* modified on Fri Mar 27 01:48:28 1992 by steveg *)


(* A "BooleanVBT" is a multi-filter.  Its "VBT"-child is a VBTkit
   switch of some sort (e.g., "SwitchVBT", "MenuSwitchVBT"); the
   "BooleanVBT" maintains a Boolean state for that switch.  When
   the "callback" method of the switch would normally be
   invoked, the value of the state of the "BooleanVBT" is toggled
   and the "callback" method on the "BooleanVBT" is invoked.  The
   visual feedback is provided by the switch's feedback.  An
   appropriate feedback to use is "MarginFeedbackVBT.NewCheck".

   The multi-child of a "BooleanVBT" is defined to be the
   multi-child of the switch. *)

INTERFACE BooleanVBT;

IMPORT ButtonVBT, Filter, MultiClass, VBT;

TYPE
  T <: Public;
  Public =
    Filter.T OBJECT
    METHODS
      init     (switch: ButtonVBT.T; multiclass: MC := NIL): T;
      callback (READONLY cd: VBT.MouseRec);
    END;

(* The call "v.init(switch, ...)" initializes "v" as a "BooleanVBT"
   with an initial state of "FALSE".

   Warning:  This call modifies the "action" field of "switch".  Clients
   must not change the "VBT" child of a "BooleanVBT" directly.  Clients
   can, of course, change multi-child of "v" (e.g., some displayed text
   or pixmap).

   Although all VBTkit switches are subtypes of "ButtonVBT.T", not all
   are subtypes of "SwitchVBT.T".  A "MenuSwitchVBT", for example, is
   a subtype of "MenuBtnVBT.T" and is neither a subtype nor a supertype
   of "SwitchVBT.T".  *)

TYPE MC <: MultiClass.T;
(* The type "MC" overrides the "replace", "pred", and "succ" methods
   of the type "MultiClass.T". *)

PROCEDURE Put (v: T; state: BOOLEAN);
(* Set "v"'s state. *)

PROCEDURE Get (v: T): BOOLEAN;
(* Returns "v"'s current state. *)

END BooleanVBT.

