(* Copyright (C) 1992, Digital Equipment Corporation                        *)
(* All rights reserved.                                                     *)
(* See the file COPYRIGHT for a full description.                           *)
(*                                                                          *)
(* Last modified on Sun Aug  9 19:07:14 1992 by meehan                      *)
(*      modified on Tue Jun 16 13:08:58 PDT 1992 by muller                  *)
(*      modified on Mon Jun 15 18:28:39 1992 by mhb                         *)

(* A {\em feedback}\index{feedback} ("Feedback.T") is a multi-filter 
   that provides visual feedback for its child. The essence of a 
   feedback is its methods for displaying itself in a {\em normal} 
   or {\em excited} state.  The normal style is drawn to give permanent 
   feedback, and the excited style gives transitory feedback (e.g., 
   while a button is pressed).  In addition, a feedback maintains 
   a Boolean flag so that it can distinguish between an ``on'' and 
   ``off'' state (e.g., for use by a "BooleanVBT"). 

   An arbitrary multi-filter is made into a feedback by calling
   "FeedbackClass.Be". *)

INTERFACE Feedback;

IMPORT VBT;

TYPE T = VBT.T;
(* A "Feedback" is a multi-filter with a "FeedbackClass.T" in its
   property set. *)

PROCEDURE Normal (v: T);
(* Invoke v's "normal" method. *)

PROCEDURE Excited (v: T);
(* Invoke v's "excited" method. *)

PROCEDURE SetState (v: T; state: BOOLEAN);
(* Record the "state" and then invoke whichever of "v"'s methods,
   "normal" or "excited", was most recently invoked. *)

PROCEDURE GetState (v: T): BOOLEAN;
(* Return the value of the most recent call to "SetState". *)

END Feedback.













































