(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:08:57 PDT 1992 by muller *)
(*      modified on Mon Jun 15 18:46:39 1992 by mhb    *)
(*      modified on Mon Dec  9 15:48:43 PST 1991 by meehan *)


MODULE Feedback;

IMPORT FeedbackClass;

PROCEDURE SetState (v: T; state: BOOLEAN) =
  BEGIN
    WITH c = FeedbackClass.Resolve(v) DO
      IF c.state # state THEN
        c.state := state;
        IF c.last = FeedbackClass.LastCall.Normal THEN
          c.normal()
        ELSE
          c.excited()
        END
      END
    END
  END SetState;

PROCEDURE GetState (v: T): BOOLEAN =
  BEGIN
    WITH c = FeedbackClass.Resolve(v) DO RETURN c.state END
  END GetState;

PROCEDURE Normal (v: T) =
  BEGIN
    WITH c = FeedbackClass.Resolve(v) DO
      c.last := FeedbackClass.LastCall.Normal;
      c.normal()
    END
  END Normal;

PROCEDURE Excited (v: T) =
  BEGIN
    WITH c = FeedbackClass.Resolve(v) DO
      c.last := FeedbackClass.LastCall.Excited;
      c.excited()
    END
  END Excited;

BEGIN
END Feedback.

