(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31 18:05:47 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:55 PDT 1992 by muller *)
(*      modified on Mon Jun 15 09:51:42 1992 by mhb *)

MODULE FeedbackVBT;

IMPORT Feedback, FeedbackClass, Filter, VBT;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        init := Init
      END;

REVEAL
  FC = FeedbackClass.T BRANDED OBJECT END;

PROCEDURE Init (v: T; ch: VBT.T; feedbackclass: FC := NIL): T =
  BEGIN
    EVAL Filter.T.init (v, ch);
    IF feedbackclass = NIL THEN feedbackclass := NEW (FC) END;
    FeedbackClass.Be (v, feedbackclass);
    Feedback.Normal (v);
    RETURN v
  END Init;

BEGIN
END FeedbackVBT.
