(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:08:49 PDT 1992 by muller   *)
(*      modified on Sat Jun 13 08:08:03 1992 by mhb      *)
(*      modified on Fri Nov 29 18:10:06 PST 1991 by meehan   *)
(*      modified on Fri Jul 26 15:34:03 PDT 1991 by steveg   *)

MODULE FlexVBT;

IMPORT Axis, Filter, FilterClass, FlexShape, Pts, VBT, VBTClass;

CONST Missing = FlexShape.Missing;

REVEAL
  T = Public BRANDED OBJECT
        sh: FlexShape.Shape
      OVERRIDES
        init     := Init;
        shape    := Shape;
        rescreen := Rescreen
      END;

PROCEDURE Init (v: T; ch: VBT.T; sh := FlexShape.DefaultShape): T =
  BEGIN
    EVAL Filter.T.init (v, ch);
    v.sh := sh;
    RETURN v
  END Init;

PROCEDURE New (ch: VBT.T; sh := FlexShape.DefaultShape): T =
  BEGIN
    RETURN NEW(T).init(ch, sh)
  END New;

PROCEDURE FromAxis (ch: VBT.T; ax: Axis.T; sr := FlexShape.Default): T =
  VAR sh: FlexShape.Shape;
  BEGIN
    sh [ax] := sr;
    sh [Axis.other [ax]] := FlexShape.Default;
    RETURN NEW (T).init (ch, sh);
  END FromAxis;

PROCEDURE Set (v: T; sh: FlexShape.Shape) =
  BEGIN
    v.sh := sh;
    VBT.NewShape(v);
  END Set;

PROCEDURE SetRange (v: T; ax: Axis.T; sr: FlexShape.SizeRange) =
  BEGIN
    v.sh[ax] := sr;
    VBT.NewShape(v);
  END SetRange;

PROCEDURE Shape (v: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  VAR range, chRange: VBT.SizeRange;
  BEGIN
    IF AnyMissing (v.sh [ax]) THEN
      chRange := VBTClass.GetShape(v.ch, ax, n);
      IF AllMissing (v.sh [ax]) THEN RETURN chRange; END;
    END;
    WITH sh = v.sh [ax] DO
      IF sh.natural = Missing THEN
        range.pref := chRange.pref;
      ELSE
        range.pref := Pts.ToScreenPixels (v, sh.natural, ax);
      END;
      IF sh.shrink = Missing THEN
        IF sh.natural # Missing THEN
          range.lo := range.pref;
        ELSE
          range.lo := MIN (chRange.lo, range.pref);
        END;
      ELSE
        range.lo :=
          MAX (0, range.pref - Pts.ToScreenPixels (v, sh.shrink, ax));
      END;
      IF sh.stretch = Missing THEN
        IF sh.natural # Missing THEN
          range.hi := range.pref + 1;
        ELSE
          range.hi := MAX (chRange.hi, range.pref + 1);
        END;
      ELSE
        range.hi :=
          MIN (MAX (range.pref + 1, VBT.DefaultShape.hi),
               range.pref + 1 + Pts.ToScreenPixels (v, sh.stretch, ax));
      END;
    END;
    RETURN range;
  END Shape;

PROCEDURE Rescreen (v: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    Filter.T.rescreen (v, cd);
    VBT.NewShape (v);
  END Rescreen;

PROCEDURE AllMissing (range: FlexShape.SizeRange): BOOLEAN =
  BEGIN
    RETURN (range.natural = Missing) AND 
           (range.shrink  = Missing) AND 
           (range.stretch = Missing);
  END AllMissing;

PROCEDURE AnyMissing (READONLY range: FlexShape.SizeRange): BOOLEAN =
  BEGIN
    RETURN (range.natural = Missing) OR 
           (range.shrink  = Missing) OR 
           (range.stretch = Missing);
  END AnyMissing;

(* for pre-2.0:
PROCEDURE FilterDotTDotrescreen (v: Filter.T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    VBTClass.Rescreen(Filter.Child(v), cd.st);
  END Filter.T.rescreen;
*)

BEGIN
END FlexVBT.

