(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Aug 11 20:24:58 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:34 PDT 1992 by muller *)
(*      modified on Mon Jun 15 21:49:40 1992 by mhb *)
<* PRAGMA LL *>

(* A "NumericScrollerVBT"  provides a {\em bounded-value}
   abstraction using a "ScrollerVBT" for user interaction.

   A bounded value is guaranteed to stay in the range
   "[min .. max-thumb]".  Visually, the value is represented by the
   position (left/top edge) of a stripe in the scroller, and
   thumb by the length of the stripe.  The amount that value
   should change when continuous scrolling is called the {\em
   stepping} amount. *)

INTERFACE NumericScrollerVBT;

IMPORT Axis, PaintOp, ScrollerVBT, VBT;

TYPE
  T <: Public;
  Public = ScrollerVBT.T OBJECT
           METHODS
             <* LL.sup = VBT.mu *>
             init (axis  : Axis.T;
                   min   : INTEGER;
                   max   : INTEGER;
                   colors: PaintOp.ColorQuad;
                   step  : CARDINAL            := 1;
                   thumb : CARDINAL            := 0  ): T;
             <* LL = VBT.mu *>
             callback (READONLY cd: VBT.MouseRec);
           END;

(* The call to "v.init(...)" initializes "v" as a "NumericScrollerVBT"
   in the "axis" orientation.  It is displayed using "colors".

   The implementation calls "v.callback(cd)" after "v"'s value has been
   changed by the user; it is not called when the value is
   changed as the result of calls to "Put" or "PutBounds". 
   
   The type "NumericScrollerVBT.T"\/ overrides the "scroll", "autoScroll",
   and "thumb" methods of the type "ScrollerVBT.T". *)

PROCEDURE Put (v: T; n: INTEGER);
(* Change the value of "v", projected to "[min .. max-thumb]".
   Mark "v" for redisplay. *)

PROCEDURE PutBounds (v    : T;
                     min  : INTEGER;
                     max  : INTEGER;
                     thumb: CARDINAL  := 0);
(* Set the bounds and project "v"'s value into
   "[min .. max-thumb]".  Mark "v" for redisplay *)

PROCEDURE PutStep (v: T; step: CARDINAL);
(* Change the amount that "v"'s value should change while
   continous scrolling to "step".  If "step = 0", scrolling will
   be disabled. *)

PROCEDURE Get      (v: T): INTEGER;
PROCEDURE GetMin   (v: T): INTEGER;
PROCEDURE GetMax   (v: T): INTEGER;
PROCEDURE GetThumb (v: T): CARDINAL;
PROCEDURE GetStep  (v: T): CARDINAL;
(* Return the current "value", "min", "max", "thumb", and
   "step". *)

END NumericScrollerVBT.

