(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31 17:55:23 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:16 PDT 1992 by muller *)
(*      modified on Mon Jun 15 18:28:41 1992 by mhb *)

(* A "ShadowedFeedbackVBT" is a feedback that displays a {\em
   shadow} as visual feedback to another VBT.  The default
   methods change the style of the shadow to the style indicated
   in the "init" method.  However, on a monochrome screen or when
   the shadow's size is a negative number, the "excited" method
   inverts a highlighter above itself and the "normal" method
   takes off the highlighting. *)

INTERFACE ShadowedFeedbackVBT;

IMPORT FeedbackClass, Shadow, ShadowedVBT, VBT;

TYPE
  T <: Public;
  Public =
    ShadowedVBT.T OBJECT
    METHODS
      init (ch             : VBT.T;
            shadow         : Shadow.T := NIL;
            onStyle                   := Shadow.Style.Ridged;
            onExcitedStyle            := Shadow.Style.Chiseled;
            offStyle                  := Shadow.Style.Raised;
            offExcitedStyle           := Shadow.Style.Lowered;
            feedbackclass  : FC       := NIL                    ):
            T
    END;

  FC <: FeedbackClass.T;

PROCEDURE NewMenu (ch: VBT.T; shadow: Shadow.T := NIL): T;
(* Create the standard "shadow" used for menu buttons.  The
   specification of the standard for menu buttons is as follows:
   the normal states are displayed as "Shadow.Style.Flat"; the
   excited state as "Shadow.Style.Lowered" style. *)

END ShadowedFeedbackVBT.

